/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.crypto;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractProxyVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.crypto.PGDVirtualFile;

public class PBPVirtualFile
extends AbstractProxyVirtualFile {
    private byte[] key;
    private int pgdOffset;

    public PBPVirtualFile(byte[] key, IVirtualFile vFile) {
        super(vFile);
        this.key = key;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        int result;
        switch (command) {
            case 0x4100001: {
                if (this.key != null) {
                    PGDVirtualFile pgdFile = new PGDVirtualFile(this.key, this.vFile, this.pgdOffset);
                    this.setProxyVirtualFile(pgdFile);
                } else {
                    this.ioLseek(this.pgdOffset);
                }
                result = 0;
                break;
            }
            case 68157442: {
                this.pgdOffset = inputPointer.getValue32();
                result = 0;
                break;
            }
            default: {
                result = super.ioIoctl(command, inputPointer, inputLength, outputPointer, outputLength);
            }
        }
        return result;
    }

    @Override
    public IVirtualFile duplicate() {
        PBPVirtualFile vFileDuplicate = new PBPVirtualFile(this.key, super.duplicate());
        vFileDuplicate.pgdOffset = this.pgdOffset;
        vFileDuplicate.ioLseek(this.getPosition());
        return vFileDuplicate;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        int result = super.ioRead(outputPointer, outputLength);
        if (this.key == null && outputLength == 4 && result == outputLength && outputPointer.getUnalignedValue32() == 1179403647) {
            outputPointer.setUnalignedValue32(0, 1347637374);
        }
        return result;
    }
}

